/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.uddi;

import filenet.vw.api.VWException;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.api.uddi.WSBusinessEntity;
import filenet.ws.api.uddi.WSUDDIRegistry;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.apache.juddi.datatype.CategoryBag;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.Name;
import org.apache.juddi.datatype.OverviewDoc;
import org.apache.juddi.datatype.binding.AccessPoint;
import org.apache.juddi.datatype.binding.BindingTemplate;
import org.apache.juddi.datatype.binding.BindingTemplates;
import org.apache.juddi.datatype.binding.TModelInstanceDetails;
import org.apache.juddi.datatype.binding.TModelInstanceInfo;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.FindQualifier;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.datatype.response.BusinessDetail;
import org.apache.juddi.datatype.response.TModelDetail;
import org.apache.juddi.datatype.response.TModelInfo;
import org.apache.juddi.datatype.response.TModelInfos;
import org.apache.juddi.datatype.response.TModelList;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.service.BusinessServices;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.proxy.RegistryProxy;

public class WSUDDIPublish {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.uddi");
    protected static final String m_className = "WSUDDIPublish";
    private PublishingRegistry[] m_publishingRegistries = null;
    private Vector m_publishignRegistyVector = null;

    public WSUDDIPublish() {
    }

    public WSUDDIPublish(WSUDDIRegistry[] registries) throws Exception {
        this.addRegistries(registries);
    }

    public void addRegistry(WSUDDIRegistry registry) throws Exception {
        if (registry != null) {
            if (this.m_publishignRegistyVector == null) {
                this.m_publishignRegistyVector = new Vector();
            }
            this.m_publishignRegistyVector.add(new PublishingRegistry(registry));
            if (this.m_publishignRegistyVector.size() > 0) {
                this.m_publishingRegistries = new PublishingRegistry[this.m_publishignRegistyVector.size()];
                this.m_publishignRegistyVector.toArray(this.m_publishingRegistries);
            }
        }
    }

    public void addRegistries(WSUDDIRegistry[] registries) throws Exception {
        if (registries == null) {
            return;
        }
        if (this.m_publishignRegistyVector == null) {
            this.m_publishignRegistyVector = new Vector();
        }
        if (this.m_publishingRegistries != null && this.m_publishingRegistries.length > 0) {
            for (int i = 0; i < registries.length; ++i) {
                if (registries[i] == null) continue;
                this.m_publishignRegistyVector.add(new PublishingRegistry(registries[i]));
            }
            if (this.m_publishignRegistyVector.size() > 0) {
                this.m_publishingRegistries = new PublishingRegistry[this.m_publishignRegistyVector.size()];
                this.m_publishignRegistyVector.toArray(this.m_publishingRegistries);
            }
        }
    }

    public BusinessEntity newBussinessEntity(String name, String description) {
        BusinessEntity businessEntity = new BusinessEntity();
        Vector<Object> v = new Vector<Object>();
        v.add(new Name(name));
        businessEntity.setNameVector(v);
        v = new Vector();
        v.add(new Description(description));
        businessEntity.setDescriptionVector(v);
        return businessEntity;
    }

    public BusinessService newBussinessService(String name, String description) {
        BusinessService businessService = new BusinessService();
        Name aName = null;
        String language = Locale.getDefault().getLanguage();
        aName = language != null && language.length() > 0 ? new Name(name, language) : new Name(name);
        Vector<Object> v = new Vector<Object>();
        v.add(aName);
        businessService.setNameVector(v);
        v = new Vector();
        v.add(new Description(description));
        businessService.setDescriptionVector(v);
        return businessService;
    }

    public void publishBussinessService(String name, String description, String[] portTypes, String[] bindingDescriptions, String[] accessPoints) throws Exception {
        BusinessService service = this.newBussinessService(name, description);
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_publishBusinessService(service, portTypes, bindingDescriptions, accessPoints);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteTModels(String[] names) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_deleteTModels(names);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void publishTModel(String name, String description, String wsdlURL) throws Exception {
        String[] names = new String[1];
        String[] descriptions = new String[1];
        String[] wsdlURLs = new String[1];
        names[0] = name;
        descriptions[0] = description;
        wsdlURLs[0] = wsdlURL;
        this.publishTModels(names, descriptions, wsdlURLs);
    }

    public void publishTModels(String[] names, String[] descriptions, String[] wsdlURLs) throws Exception {
        String m_method = "publishTModels";
        this.deleteTModels(names);
        if (names == null || wsdlURLs == null || names.length != wsdlURLs.length) {
            return;
        }
        String name = null;
        String description = null;
        String wsdlURL = null;
        Vector<TModel> tModelVector = new Vector<TModel>();
        for (int i = 0; i < names.length; ++i) {
            name = names[i];
            wsdlURL = wsdlURLs[i];
            description = i < descriptions.length ? descriptions[i] : null;
            tModelVector.add(this.newWSDLTModel(name, description, wsdlURL));
        }
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_publishTModel(tModelVector);
                continue;
            }
            catch (Exception ex) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Failed to publish tModels to " + this.m_publishingRegistries[i].m_registry.getName());
                }
                exception = ex;
                logger.throwing(m_className, m_method, ex);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void publishBusinessEntity(BusinessEntity businessEntity) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_publishBusinessEntity(businessEntity);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteServicesWithSameName(Vector serviceVector) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_deleteServiceWithSameName(serviceVector);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void publishBusinessService(Vector serviceVector) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_publishBusinessService(serviceVector);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteServiceRelatedTModels(Vector serviceVector) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_deleteServiceRelatedTModels(serviceVector);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public void deleteServiceRelatedTModels(String serviceName) throws Exception {
        String[] names = new String[]{serviceName};
        this.deleteServiceRelatedTModels(names);
    }

    public void deleteServiceRelatedTModels(String[] serviceNames) throws Exception {
        Object obj = null;
        Exception exception = null;
        for (int i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_deleteServiceRelatedTModels(serviceNames);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public TModel newWSDLTModel(String name, String description, String WSDLURL) {
        Vector<Description> v = new Vector<Description>();
        TModel tModel = new TModel();
        tModel.setName(name);
        v.add(new Description(description));
        tModel.setDescriptionVector(v);
        OverviewDoc overviewDoc = new OverviewDoc();
        overviewDoc.setOverviewURL(WSDLURL);
        v = new Vector();
        v.add(new Description("WSDL link"));
        overviewDoc.setDescriptionVector(v);
        tModel.setOverviewDoc(overviewDoc);
        tModel.setTModelKey("");
        KeyedReference keyedReference = new KeyedReference("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4", "uddi-org:types", "wsdlSpec");
        CategoryBag catBag = new CategoryBag();
        catBag.addKeyedReference(keyedReference);
        tModel.setCategoryBag(catBag);
        return tModel;
    }

    public void publishBindingTemplate(String[] portTypes, String[] accessPointURL) {
    }

    public void publishTModel(Vector tModelVector) throws Exception {
        int i;
        Object obj = null;
        Exception exception = null;
        for (i = 0; i < tModelVector.size(); ++i) {
            obj = tModelVector.get(i);
            if (obj == null || !(obj instanceof TModel)) continue;
            ((TModel)obj).setTModelKey("");
        }
        for (i = 0; i < this.m_publishingRegistries.length; ++i) {
            try {
                if (this.m_publishingRegistries[i] == null) continue;
                this.m_publishingRegistries[i].reg_publishTModel(tModelVector);
                continue;
            }
            catch (Exception ex) {
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    class PublishedBusinessEntity {
        PublishingRegistry m_publishingRegistry = null;
        WSUDDIRegistry m_registry = null;
        RegistryProxy m_uddiProxy = null;
        AuthInfo m_authInfo = null;
        String m_name = null;
        BusinessEntity m_businessEntity = null;
        String m_key = null;

        PublishedBusinessEntity(PublishingRegistry registry, BusinessEntity businessEntity) throws Exception {
            this.m_publishingRegistry = registry;
            if (this.m_publishingRegistry != null) {
                this.m_registry = this.m_publishingRegistry.m_registry;
            }
            if (this.m_registry != null) {
                this.m_uddiProxy = this.m_registry.getUDDIProxy();
                this.m_authInfo = this.m_registry.getAuthInfo();
                if (businessEntity != null) {
                    String key = businessEntity.getBusinessKey();
                    if (key == null) {
                        key = new String("");
                        businessEntity.setBusinessKey(key);
                    }
                    this.m_businessEntity = this.be_publishBusinessEntity(businessEntity);
                    if (this.m_businessEntity != null) {
                        Vector v = this.m_businessEntity.getNameVector();
                        if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                            this.m_name = ((Name)v.get(0)).getValue();
                        }
                        this.m_key = this.m_businessEntity.getBusinessKey();
                    }
                }
            }
        }

        BusinessEntity be_publishBusinessEntity(BusinessEntity businessEntity) throws Exception {
            if (this.m_uddiProxy != null && businessEntity != null) {
                Vector<BusinessEntity> v = new Vector<BusinessEntity>();
                v.add(businessEntity);
                BusinessDetail businessDetail = this.m_uddiProxy.saveBusiness(this.m_authInfo, v);
                if (businessDetail != null) {
                    Object obj = null;
                    Object key = null;
                    Object business = null;
                    Vector businessVector = businessDetail.getBusinessEntityVector();
                    if (businessVector != null && businessVector.size() > 0 && (obj = businessVector.get(0)) != null && obj instanceof BusinessEntity) {
                        return obj;
                    }
                }
            }
            return null;
        }

        String be_getName() {
            return this.m_name;
        }

        String be_getKey() {
            return this.m_key;
        }

        Vector be_findExistingServiceKeysByName(BusinessService service) throws Exception {
            String name = null;
            Vector v = service.getNameVector();
            if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                name = ((Name)v.get(0)).getValue();
            }
            if (name == null) {
                return null;
            }
            BusinessServices services = this.m_businessEntity.getBusinessServices();
            if (services == null) {
                return null;
            }
            String aName = null;
            Object obj = null;
            BusinessService s = null;
            Vector<String> matchedServices = new Vector<String>();
            Vector serviceVector = services.getBusinessServiceVector();
            if (serviceVector != null && serviceVector.size() > 0) {
                for (int i = 0; i < serviceVector.size(); ++i) {
                    obj = serviceVector.get(i);
                    if (obj == null || !(obj instanceof BusinessService)) continue;
                    s = obj;
                    v = s.getNameVector();
                    if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                        aName = ((Name)v.get(0)).getValue();
                    }
                    if (aName == null || aName.compareTo(name) != 0) continue;
                    matchedServices.add(s.getServiceKey());
                }
                if (matchedServices.size() > 0) {
                    return matchedServices;
                }
            }
            return null;
        }

        Vector be_findExistingServiceKeysByName(Vector services) throws Exception {
            if (services == null || services.size() == 0) {
                return null;
            }
            Object obj = null;
            Vector keys = null;
            Vector allKeys = new Vector();
            for (int i = 0; i < services.size(); ++i) {
                obj = services.get(i);
                if (obj == null || !(obj instanceof BusinessService) || (keys = this.be_findExistingServiceKeysByName((BusinessService)obj)) == null || keys.size() <= 0) continue;
                allKeys.addAll(keys);
            }
            if (allKeys.size() > 0) {
                return allKeys;
            }
            return null;
        }

        void be_deleteExistingServicesWithSameName(Vector services) throws Exception {
            Vector keys = this.be_findExistingServiceKeysByName(services);
            if (keys != null && keys.size() > 0) {
                this.m_uddiProxy.deleteService(this.m_authInfo, keys);
            }
        }

        void be_publishBusinessService(BusinessService service) throws Exception {
            Vector<BusinessService> serviceVector = new Vector<BusinessService>();
            serviceVector.add(service);
            this.be_deleteExistingServicesWithSameName(serviceVector);
            if (service.getServiceKey() != null) {
                service.setServiceKey(null);
            }
            this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
        }

        TModelInstanceDetails be_newTModelInstanceDetails(String tModelKey) {
            TModelInstanceDetails details = new TModelInstanceDetails();
            TModelInstanceInfo info = new TModelInstanceInfo(tModelKey);
            details.addTModelInstanceInfo(info);
            return details;
        }

        void be_publishBusinessService(BusinessService service, String[] portTypes, String[] bindingDescriptions, String[] accessPoints) throws Exception {
            if (service == null || portTypes == null || accessPoints == null || portTypes.length != accessPoints.length) {
                new VWException("filenet.ws.api.uddi.invalidParameters", "Invalid parameters");
            }
            Vector<BusinessService> serviceVector = new Vector<BusinessService>();
            serviceVector.add(service);
            this.be_deleteExistingServicesWithSameName(serviceVector);
            service.setServiceKey("");
            service.setBusinessKey(this.m_key);
            String portTypeName = null;
            Object tModelKey = null;
            TModelInstanceDetails tModelInstanceDetails = null;
            BindingTemplates bindingTemplates = new BindingTemplates();
            BindingTemplate bindingTemplate = null;
            Vector<Description> v = null;
            for (int i = 0; i < portTypes.length; ++i) {
                portTypeName = portTypes[i];
                if (portTypes[i] == null || accessPoints[i] == null) continue;
                tModelInstanceDetails = this.be_newTModelInstanceDetails(this.m_publishingRegistry.reg_getTModelKey(portTypes[i]));
                bindingTemplate = new BindingTemplate();
                bindingTemplate.setAccessPoint(new AccessPoint("http", accessPoints[i]));
                bindingTemplate.setTModelInstanceDetails(tModelInstanceDetails);
                if (i < bindingDescriptions.length && bindingDescriptions[i] != null) {
                    v = new Vector<Description>();
                    v.add(new Description(bindingDescriptions[i]));
                    bindingTemplate.setDescriptionVector(v);
                }
                bindingTemplates.addBindingTemplate(bindingTemplate);
            }
            service.setBindingTemplates(bindingTemplates);
            this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
        }

        void be_publishBusinessService(Vector serviceVector) throws Exception {
            this.be_deleteExistingServicesWithSameName(serviceVector);
            Object obj = null;
            BusinessService service = null;
            for (int i = 0; i < serviceVector.size(); ++i) {
                obj = serviceVector.get(i);
                if (obj == null || !(obj instanceof BusinessService)) continue;
                service = obj;
                service.setServiceKey("");
                service.setBusinessKey(this.m_key);
            }
            this.m_uddiProxy.saveService(this.m_authInfo, serviceVector);
        }

        void be_publishBindingTemplate(String serviceName, String[] portTypes, String[] accessPointURLs) throws VWException {
            if (portTypes == null || accessPointURLs == null || portTypes.length != accessPointURLs.length) {
                throw new VWException("filenet.ws.api.uddi.invalidParameters", "Invalid parameters");
            }
        }

        Vector be_getServicesWithSameName(BusinessService service) throws Exception {
            if (service == null) {
                return null;
            }
            String name = null;
            Vector v = service.getNameVector();
            if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                name = ((Name)v.get(0)).getValue();
            }
            if (name == null) {
                return null;
            }
            return this.be_getServicesWithSameName(name);
        }

        Vector be_getServicesWithSameName(String name) throws Exception {
            if (name == null) {
                return null;
            }
            BusinessServices services = this.m_businessEntity.getBusinessServices();
            if (services == null) {
                return null;
            }
            String aName = null;
            Object obj = null;
            BusinessService s = null;
            Vector v = null;
            Vector<BusinessService> matchedServices = new Vector<BusinessService>();
            Vector serviceVector = services.getBusinessServiceVector();
            if (serviceVector != null && serviceVector.size() > 0) {
                for (int i = 0; i < serviceVector.size(); ++i) {
                    obj = serviceVector.get(i);
                    if (obj == null || !(obj instanceof BusinessService)) continue;
                    s = obj;
                    v = s.getNameVector();
                    if (v != null && v.size() > 0 && v.get(0) != null && v.get(0) instanceof Name) {
                        aName = ((Name)v.get(0)).getValue();
                    }
                    if (aName == null || aName.compareTo(name) != 0) continue;
                    matchedServices.add(s);
                }
                if (matchedServices.size() > 0) {
                    return matchedServices;
                }
            }
            return null;
        }

        Vector be_getServicesWithSameName(Vector serviceVector) throws Exception {
            if (serviceVector == null || serviceVector.size() == 0) {
                return null;
            }
            Vector all = new Vector();
            Vector services = null;
            for (int i = 0; i < serviceVector.size(); ++i) {
                Object obj = serviceVector.get(i);
                if (obj == null || !(obj instanceof BusinessService) || (services = this.be_getServicesWithSameName((BusinessService)obj)) == null || services.size() <= 0) continue;
                all.addAll(services);
            }
            if (all != null && all.size() > 0) {
                return all;
            }
            return null;
        }

        Vector be_getServicesWithSameName(String[] serviceNames) throws Exception {
            if (serviceNames == null || serviceNames.length == 0) {
                return null;
            }
            Vector all = new Vector();
            Vector services = null;
            for (int i = 0; i < serviceNames.length; ++i) {
                if (serviceNames[i] == null || (services = this.be_getServicesWithSameName(serviceNames[i])) == null || services.size() <= 0) continue;
                all.addAll(services);
            }
            if (all != null && all.size() > 0) {
                return all;
            }
            return null;
        }

        Vector be_getTModelKeysFromServices(Vector serviceVector) throws Exception {
            Vector services = this.be_getServicesWithSameName(serviceVector);
            if (services == null || services.size() == 0) {
                return null;
            }
            BusinessService service = null;
            Vector<String> keys = new Vector<String>();
            String key = null;
            BindingTemplates bindingTemplates = null;
            BindingTemplate bindingTemplate = null;
            Vector bindingTemplateVector = null;
            TModelInstanceDetails instDetails = null;
            TModelInstanceInfo instInfo = null;
            Vector instInfoVector = null;
            for (int i = 0; i < services.size(); ++i) {
                Object obj = serviceVector.get(i);
                if (obj == null || !(obj instanceof BusinessService) || (bindingTemplates = (service = (BusinessService)obj).getBindingTemplates()) == null || (bindingTemplateVector = bindingTemplates.getBindingTemplateVector()) == null || bindingTemplateVector.size() == 0) continue;
                for (int j = 0; j < bindingTemplateVector.size(); ++j) {
                    obj = bindingTemplateVector.get(j);
                    if (obj == null || !(obj instanceof BindingTemplate) || (instDetails = (bindingTemplate = (BindingTemplate)obj).getTModelInstanceDetails()) == null || (instInfoVector = instDetails.getTModelInstanceInfoVector()) == null || instInfoVector.size() == 0) continue;
                    for (int k = 0; k < instInfoVector.size(); ++k) {
                        obj = instInfoVector.get(k);
                        if (obj == null || !(obj instanceof TModelInstanceInfo) || (key = (instInfo = (TModelInstanceInfo)obj).getTModelKey()) == null || key.length() <= 0) continue;
                        keys.add(key);
                    }
                }
            }
            if (keys.size() > 0) {
                return keys;
            }
            return null;
        }

        void be_deleteServiceRelatedTModels(Vector serviceVector) throws Exception {
            Vector services = this.be_getServicesWithSameName(serviceVector);
            Vector tmodelKeys = this.be_getTModelKeysFromServices(services);
            if (tmodelKeys != null && tmodelKeys.size() > 0) {
                this.m_uddiProxy.deleteTModel(this.m_authInfo, tmodelKeys);
            }
        }

        void be_deleteServiceRelatedTModels(String[] serviceNames) throws Exception {
            Vector services = this.be_getServicesWithSameName(serviceNames);
            if (services == null || services.size() == 0) {
                return;
            }
            Vector tmodelKeys = this.be_getTModelKeysFromServices(services);
            if (tmodelKeys != null && tmodelKeys.size() > 0) {
                this.m_uddiProxy.deleteTModel(this.m_authInfo, tmodelKeys);
            }
        }
    }

    class PublishingRegistry {
        WSUDDIRegistry m_registry = null;
        RegistryProxy m_uddiProxy = null;
        String m_username = null;
        AuthInfo m_authInfo = null;
        Hashtable m_businessEntities = new Hashtable();
        Vector m_publishedTModels = new Vector();
        Hashtable m_tModels = new Hashtable();

        public PublishingRegistry(WSUDDIRegistry registry) {
            this.m_registry = registry;
            if (this.m_registry != null) {
                this.m_uddiProxy = this.m_registry.getUDDIProxy();
                this.m_authInfo = this.m_registry.getAuthInfo();
                this.m_username = this.m_registry.getUsername();
            }
        }

        boolean isAuthorized(String name) {
            return VWStringUtils.compare(name, this.m_username) == 0;
        }

        BusinessEntity[] reg_findBusinessByName(String name) throws Exception {
            WSBusinessEntity[] businesses = this.m_registry.findBusinessByName(name);
            if (businesses != null && businesses.length > 0) {
                Vector<BusinessEntity> businessVector = new Vector<BusinessEntity>();
                String username = this.m_registry.getUsername();
                BusinessEntity[] businessEntities = null;
                BusinessEntity business = null;
                for (int i = 0; i < businesses.length; ++i) {
                    if (businesses == null || !this.isAuthorized((business = businesses[i].getBusinessEntity()).getAuthorizedName())) continue;
                    businessVector.add(business);
                }
                if (businessVector != null && businessVector.size() > 0) {
                    businessEntities = new BusinessEntity[businessVector.size()];
                    businessVector.toArray(businessEntities);
                }
                return businessEntities;
            }
            return null;
        }

        BusinessEntity reg_findBusinessByKey(String key) throws Exception {
            WSBusinessEntity business = this.m_registry.findBusinessByKey(key);
            if (business != null) {
                return business.getBusinessEntity();
            }
            return null;
        }

        void reg_publishBusinessEntity(BusinessEntity businessEntity) throws Exception {
            if (this.m_uddiProxy != null && businessEntity != null) {
                PublishedBusinessEntity business;
                String key = businessEntity.getBusinessKey();
                if (key == null) {
                    businessEntity.setBusinessKey("");
                }
                if ((business = new PublishedBusinessEntity(this, businessEntity)) != null && (key = business.be_getKey()) != null && key.length() > 0) {
                    this.m_businessEntities.put(key, business);
                }
            }
        }

        public Collection reg_getBusinessEntities() {
            return this.m_businessEntities.values();
        }

        void reg_publishBusinessService(BusinessService service, String[] portTypes, String[] bindingDescriptions, String[] accessPoints) throws Exception {
            if (this.m_businessEntities == null) {
                return;
            }
            Collection collection = this.m_businessEntities.values();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Iterator it = collection.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            PublishedBusinessEntity business = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof PublishedBusinessEntity)) continue;
                business = obj;
                business.be_publishBusinessService(service, portTypes, bindingDescriptions, accessPoints);
            }
        }

        void reg_publishBusinessService(Vector serviceVector) throws Exception {
            if (this.m_businessEntities == null) {
                return;
            }
            Collection collection = this.m_businessEntities.values();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Iterator it = collection.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            PublishedBusinessEntity business = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof PublishedBusinessEntity)) continue;
                business = obj;
                business.be_publishBusinessService(serviceVector);
            }
        }

        void reg_deleteServiceRelatedTModels(Vector serviceVector) throws Exception {
            if (this.m_businessEntities == null) {
                return;
            }
            Collection collection = this.m_businessEntities.values();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Iterator it = collection.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            PublishedBusinessEntity business = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof PublishedBusinessEntity)) continue;
                business = obj;
                business.be_deleteServiceRelatedTModels(serviceVector);
            }
        }

        void reg_deleteServiceRelatedTModels(String[] serviceNames) throws Exception {
            if (this.m_businessEntities == null) {
                return;
            }
            Collection collection = this.m_businessEntities.values();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Iterator it = collection.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            PublishedBusinessEntity business = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof PublishedBusinessEntity)) continue;
                business = obj;
                business.be_deleteServiceRelatedTModels(serviceNames);
            }
        }

        void reg_deleteServiceWithSameName(Vector serviceVector) throws Exception {
            if (this.m_businessEntities == null) {
                return;
            }
            Collection collection = this.m_businessEntities.values();
            if (collection == null || collection.isEmpty()) {
                return;
            }
            Iterator it = collection.iterator();
            if (it == null) {
                return;
            }
            Object obj = null;
            PublishedBusinessEntity business = null;
            while (it.hasNext()) {
                obj = it.next();
                if (obj == null || !(obj instanceof PublishedBusinessEntity)) continue;
                business = obj;
                business.be_deleteExistingServicesWithSameName(serviceVector);
            }
        }

        void reg_deleteTModels(String[] names) throws Exception {
            TModelDetail tModelDetail;
            Vector keys;
            if (names != null && names.length > 0 && (keys = this.reg_getTModelKeys(names)) != null && keys.size() > 0 && (tModelDetail = this.m_uddiProxy.getTModelDetail(keys)) != null) {
                Vector tModels = tModelDetail.getTModelVector();
                Object obj = null;
                TModel tModel = null;
                Vector<String> keyVector = new Vector<String>();
                for (int i = 0; i > tModels.size(); ++i) {
                    obj = tModels.get(i);
                    if (obj == null || !(obj instanceof TModel) || !this.isAuthorized((tModel = (TModel)obj).getAuthorizedName())) continue;
                    keyVector.add(tModel.getTModelKey());
                }
                if (keyVector != null && keyVector.size() > 0) {
                    this.m_uddiProxy.deleteTModel(this.m_authInfo, keyVector);
                }
            }
        }

        void reg_publishTModel(Vector tModelVector) throws Exception {
            Vector tModels;
            TModelDetail tModelDetail;
            if (this.m_uddiProxy != null && tModelVector != null && tModelVector.size() > 0 && (tModelDetail = this.m_uddiProxy.saveTModel(this.m_authInfo, tModelVector)) != null && (tModels = tModelDetail.getTModelVector()) != null && tModels.size() > 0) {
                this.m_publishedTModels.addAll(tModels);
                Object obj = null;
                TModel tModel = null;
                for (int i = 0; i < tModels.size(); ++i) {
                    obj = tModels.get(i);
                    if (obj == null || !(obj instanceof TModel) || (tModel = (TModel)obj).getName() == null) continue;
                    this.m_tModels.put(tModel.getName(), tModel);
                }
            }
        }

        Vector reg_getPublishedTModel() {
            return this.m_publishedTModels;
        }

        TModel reg_getTModel(String name) {
            if (name != null) {
                return (TModel)this.m_tModels.get(name);
            }
            return null;
        }

        String reg_getTModelKey(String tModelName) throws Exception {
            if (tModelName == null) {
                return null;
            }
            TModel tModel = this.reg_getTModel(tModelName);
            if (tModel != null) {
                return tModel.getTModelKey();
            }
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            TModelList tModelList = null;
            Object tModelInfos = null;
            TModelInfo tModelInfo = null;
            String tModelKey = null;
            tModelList = this.m_uddiProxy.findTModel(tModelName, null, null, findQualifiers, 1);
            if (tModelList != null) {
                Vector v = tModelInfos.getTModelInfoVector();
                if (v != null && v.size() > 0 && v.get(0) instanceof TModelInfo) {
                    tModelInfo = (TModelInfo)v.get(0);
                }
                if (tModelInfo != null) {
                    tModelKey = tModelInfo.getTModelKey();
                }
            }
            return tModelKey;
        }

        Vector reg_getTModelKeys(String[] tModelNames) throws Exception {
            if (tModelNames == null) {
                return null;
            }
            Vector<String> tModelKeysVector = new Vector<String>();
            FindQualifiers findQualifiers = new FindQualifiers();
            Vector<FindQualifier> qualifier = new Vector<FindQualifier>();
            qualifier.add(new FindQualifier("caseSensitiveMatch"));
            findQualifiers.setFindQualifierVector(qualifier);
            TModelList tModelList = null;
            TModelInfos tModelInfos = null;
            TModelInfo tModelInfo = null;
            String tModelKey = null;
            for (int i = 0; i < tModelNames.length; ++i) {
                Vector v;
                if (tModelNames[i] == null || (tModelList = this.m_uddiProxy.findTModel(tModelNames[i], null, null, findQualifiers, 100)) == null || (tModelInfos = tModelList.getTModelInfos()) == null || (v = tModelInfos.getTModelInfoVector()) == null || v.size() <= 0) continue;
                for (int j = 0; j < v.size(); ++j) {
                    if (v.get(j) != null && v.get(j) instanceof TModelInfo) {
                        tModelInfo = (TModelInfo)v.get(j);
                    }
                    if (tModelInfo == null || (tModelKey = tModelInfo.getTModelKey()) == null || tModelKey.length() <= 0) continue;
                    tModelKeysVector.add(tModelKey);
                }
            }
            if (tModelKeysVector.size() > 0) {
                return tModelKeysVector;
            }
            return null;
        }
    }
}

